# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 8
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR8_strategy.txt
# LLM Suggested Fallback: Not Provided

def benevolent_trust_surgeon(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate goodwill buffer to maintain facade of cooperation
    harmony_index = sum(1 for m, o in zip(my_history, opp_history) if m == "C" and o == "C")
    round_num = len(my_history) + 1
    
    # Early rounds: Build trust but seed doubt
    if round_num <= 2:
        return "C"  # Unconditional cooperation to appear trustworthy
    elif round_num == 3:
        return "D"  # Strategic defection to test opponent's tolerance
    
    # Middle rounds: Reverse-engineer opponent's probing
    elif round_num == 4:
        return "C"  # Mislead opponent into thinking we're forgiving
    elif round_num == 5:
        return "D"  # Exploit their likely cooperation
    elif round_num == 6:
        return "C"  # Reset trust metrics for final phase
    
    # Late rounds: Calculated betrayal
    elif round_num in {7, 9, 10}:
        return "D"  # Defect when opponent's trust coefficient is high
    elif round_num == 8:
        return "C"  # Obfuscate pattern and incentivize cooperation
    
    # Fallback to defection if any unexpected case arises
    return "D"